package com.zjty.efs.ftp.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@AutoDocument
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "MergeResponse",description = "合并响应体")
public class MergeResponse {
    @ApiModelProperty(name = "name",value = "上传文件名称",notes = "上传文件名称",example = "1.zip")
    private String name;//上传文件的名称
    @ApiModelProperty(name = "path",value = "上传文件服务器中存储地址",notes = "上传文件服务器中存储地址",example = "D://file/uploads/1.zip")
    private String path;//上传文件的地址
    @ApiModelProperty(name = "saveSuccess",value = "文件保存是否成功",notes = "文件保存是否成功 0-失败 1-成功",example = "1")
    private int saveSuccess;//文件保存是否成功 0-失败 1-成功
}
