package com.zjty.efs.ftp.service;


import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.entity.CheckChunkRequest;
import com.zjty.efs.ftp.entity.MergeRequest;
import com.zjty.efs.ftp.entity.UploadRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

public interface FileUploadService {

    /**
     * 文件上传
     * @param request
     * @return
     */
    ServerResponse fileUpload(HttpServletRequest request);

    /**
     * @author zs
     * 检查文件存在与否
     */
    ServerResponse checkFile(String md5File);

    /**
     * @author zs
     * 检查分片存不存在
     */
    ServerResponse checkChunk(List<CheckChunkRequest> checkChunkRequests);

    /**
     * @author zs
     * 修改上传
     */
    ServerResponse upload(MultipartFile file, String md5File, Integer chunk);

    /**
     * @author zs
     * 合成分片
     */
    ServerResponse  merge(List<MergeRequest> uploadRequests);

}
