package com.zjty.efs.bus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.lang.annotation.Documented;
import java.util.Date;

@AutoDocument
//@ApiModel(value = "提醒", description = "提醒实体类")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@Table(name = "attention")
public class Attention {
    /**
     * id
     */
    @ApiModelProperty(value = "id", example = "1")
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private int id;

    /**
     * 标题
     */
    @ApiModelProperty(value = "data", example = "您收到来自XX单位的文件，请及时查收。", dataType = "String", name = "提醒内容")
    @Column(name = "data")
    private String data;

    /**
     * 通知编号
     */
    @ApiModelProperty(value = "noticeId", example = "1", dataType = "int", name = "通知编号")
    @Column(name = "notice_id")
    private int noticeId;

    /**
     * 当前用户
     */
    @ApiModelProperty(value = "userId", example = "1", dataType = "String", name = "当前用户编号")
    @Column(name = "user_id")
    private String userId;

    /**
     * 状态
     */
    @ApiModelProperty(value = "status", example = "1", dataType = "int", name = "状态", notes = "未查看　０，已查看　１")
    @Column(name = "status")
    private int status;

    @ApiModelProperty(value = "updateTime", name = "更新时间")
    @Column(name = "update_time")
//    @JsonFormat(pattern = "yyyy:HH:dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}
