package com.zjty.efs.bus.service.impl;

import com.zjty.efs.bus.Dao.NoticeDao;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.bus.service.NoticeService;
import com.zjty.efs.log.subject.entity.EfsLog;
import com.zjty.efs.log.tool.EfsLogUtil;
import com.zjty.efs.user.subject.entity.UserDo;
import com.zjty.efs.user.subject.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Transient;
import org.springframework.data.domain.*;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service
public class NoticeServiceImpl implements NoticeService {
    @Autowired
    NoticeDao noticeDao;
    @Autowired
    EfsLogUtil efsLogUtil;
    @Autowired
    UserService userService;
    @Override
    @Transactional
    public boolean addNotice(Notice notice) {
        try{

            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DATE, 7);
            UserDo userDo = userService.findById(notice.getSender()); // 发送人

            notice.setUpdateTime(new Date());
            notice.setDeadline(calendar.getTime());
            notice.setUnit(userDo.getUnit());
            notice.setStatus(0);

            String data = "";

            if(notice.getType() == 2){
                //如果是草稿
                data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                        + "]新增关于[" + notice.getTitle() + "草稿";
            }else {
                //如果是发送，就新增接收

                String[] addressees = notice.getAddressee().split(",");
                for (String addressee:addressees){
                    notice.setAddressee(addressee);
                    noticeDao.save(notice);

                    UserDo userDo1 = userService.findById(addressee); //接收人

                    data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                            + "]给[" + userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
                            + "发送了关于[" + notice.getTitle() + "]的通知";
                    Notice notice1 = new Notice();
                    notice1.setType(0);
                    notice1.setTitle(notice.getTitle());
                    notice1.setAddressee(addressee);
                    notice1.setDeadline(notice.getDeadline());
                    notice1.setFileList(notice.getFileList());
                    notice1.setMessage(notice.getMessage());
                    notice1.setNote(notice.getNote());
                    notice1.setSender(notice.getSender());
                    notice1.setStatus(notice.getStatus());
                    notice1.setUpdateTime(notice.getUpdateTime());
                    notice1.setUnit(userDo1.getUnit());
                    noticeDao.save(notice1);
                    String data1 = "[" +userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
                            + "]收到了来自[" + userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                            + "]关于[" + notice.getTitle() + "的通知";
                    efsLogUtil.addLog(new EfsLog(null, userDo1.getId(), data1, new Date()));
                }

            }
            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));
            return true;

        }catch (Exception e){
            e.printStackTrace();
            return false;
        }

    }

    @Override
    @Transactional
    public boolean updateNotice(Notice notice) {
        try{
            notice.setStatus(0);
            noticeDao.save(notice);
            return true;

        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @Transactional
    public Notice getNotice(int id) {
        try {
            Notice notice = noticeDao.findById(id);
            notice.setStatus(1);
            noticeDao.save(notice);
            String userId = "";

            if (notice.getType() == 0){
                //已接收
                userId = notice.getAddressee();
            }else {
                userId = notice.getSender();
            }
            UserDo userDo = userService.findById(userId); // 发送人
            String data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                    + "查看了关于[" + notice.getTitle() + "的通知";
            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));
            return notice;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }

    @Override
    public Paging<Notice> getReceiveList(String user, int type, int pageNum, int pageSize) {

        Pageable pageable = PageRequest.of(pageNum - 1, pageSize, Sort.Direction.DESC,"updateTime");
        Page<Notice> p;

        if (type == 0){
            //已接收
            p = noticeDao.findOutByAddresseeAndType(user, type, pageable);
        }else {
            //已发送，草稿
            p = noticeDao.findOutBySenderAndType(user, type, pageable);
        }

        Paging<Notice> paging = new Paging<>();
        paging.setData(p.getContent());
        paging.setPageSize(pageSize);
        paging.setPageNum(pageNum);
        paging.setTotal((int)p.getTotalElements());
        return paging;
    }

    @Override
    @Transactional
    public boolean updateStatus(List<Notice> notices) {
        try {
            String userId = "";
            if (notices.get(0).getType() == 0){
                userId = notices.get(0).getAddressee();
            }else {
                userId = notices.get(0).getSender();
            }
            UserDo userDo = userService.findById(userId); // 发送人
            String data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                    + "修改";
            for (Notice notice:notices){
                notice.setStatus(1);
                noticeDao.save(notice);
                data = data + "[" + notice.getTitle() + "]";
            }
            data = data + "为已读";


            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Notice> findBySender(String userId, int status, int type) {
        try{
            return noticeDao.findOutByStatusAndType(status, type);
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }
    }


}
