package com.zjty.efs.bus.controller;

import com.alibaba.fastjson.JSONObject;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.service.NoticeService;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

@AutoDocument
@Api(tags = "通知接口")
@RestController
@RequestMapping("/notice")
public class NoticeController {
    @Autowired
    private  NoticeService noticeService;


    @ApiOperation(value = "测试接口")
    @ApiImplicitParam(name = "notice", value = "", dataType = "String", paramType = "query", required = true)
    @PostMapping("/testNotice")
    public ResponseEntity test(@RequestParam String notice){
        System.out.println(notice);
        return ResponseEntity.ok(true);
    }

    /**
     * 新增通知
     * @param notice
     * @return
     */
    @ApiOperation(value = "新增通知接口")
    @ApiImplicitParam(name = "notice", value = "通知实体", dataType = "Notice", paramType = "body", required = true)
    @PostMapping("/addNotice")
    public ResponseEntity addNotice(@RequestBody @Valid Notice notice){
        System.out.println(notice);
        return ResponseEntity.ok(true);
    }

    /**
     * 修改通知
     * @param notice
     * @return
     */
    @ApiOperation(value = "修改通知接口")
    @ApiImplicitParam(name = "notice", value = "通知实体", dataType = "Notice", paramType = "body", required = true)
    @PutMapping("/updateNotice")
    public ResponseEntity updateNotice(@RequestBody @Valid Notice notice){
        System.out.println(notice);
        return ResponseEntity.ok(true);
    }

    @ApiOperation(value = "查看通知接口")
    @ApiImplicitParam(name = "id", value = "通知id", paramType = "query",
            required = true, example = "1", dataType = "int")
    @GetMapping("/getNotice")
    public ResponseEntity<Notice> getNotice(@RequestParam int id){
        System.out.println(id);
        return ResponseEntity.ok(new Notice());
    }

    @GetMapping("/getNoticeList")
    @ApiOperation(value = "获取通知列表接口", notes = "获取列表，type为通知类型，接收 0，发送 1，草稿 2，消息提醒　0")
    @ApiImplicitParams({@ApiImplicitParam(name = "user", value = "当前用户名称", paramType = "query", required = true, example = "username", dataType = "String"),
    @ApiImplicitParam(name = "type", value = "通知类型", paramType = "query", required = true, example = "0", dataType = "int"),
    @ApiImplicitParam(name = "pageNum", value = "页码", paramType = "query", required = true, dataType = "int"),
    @ApiImplicitParam(name = "pageSize", value = "条数", paramType = "query", required = true, dataType = "int")})
    public ResponseEntity<List<Notice>> getNoticeList(@RequestParam String user, int type, int pageNum, int pageSize){

        return ResponseEntity.ok(new ArrayList<>());
    }

    @PutMapping("/updateStatus")
    @ApiOperation(value = "修改通知为已读")
    @ApiImplicitParams({@ApiImplicitParam(name = "ids", value = "通知id列表", paramType = "query", required = true,
            allowMultiple = true, dataType = "int")})
    public ResponseEntity updateStatus(@RequestParam List<Integer> ids){
        System.out.println(ids);
        return ResponseEntity.ok(true);
    }


}
