package com.zjty.efs.ftp.service.impl;

import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.dao.DownLoadCountDao;
import com.zjty.efs.ftp.entity.DownLoadCount;
import com.zjty.efs.ftp.entity.DownLoadRequest;
import com.zjty.efs.ftp.service.DownLoadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class DownLoadServiceImpl implements DownLoadService {
    @Autowired
    private DownLoadCountDao downLoadCountDao;

    @Override
    public List<DownLoadCount> findCount(DownLoadRequest downLoadRequest) {
        List<DownLoadCount> loadCounts = new ArrayList<>();
        if(!downLoadRequest.getUserId().isEmpty()){
            List<Integer> fileIdList = downLoadRequest.getFileIds();//请求的id集合
            if(fileIdList != null && fileIdList.size() != 0){
                loadCounts = downLoadCountDao.findCount(downLoadRequest.getUserId(),fileIdList);
                //如果传入的文件id不存在，视为没有下载过的查询，下载过的次数为0
                if(loadCounts.size() != fileIdList.size()){
                    //没有文件id
                    List<Integer> idList = new ArrayList<>();//数据库id集合
                    for(DownLoadCount downLoadCount:loadCounts){
                        idList.add(downLoadCount.getFileId());
                    }
                    //将不存在的文件下载次数设置为0
                    for(Integer i:fileIdList){
                        if(!idList.contains(i)){
                            DownLoadCount downLoadCount = new DownLoadCount();
                            downLoadCount.setUserId(downLoadRequest.getUserId());
                            downLoadCount.setFileId(i);
                            downLoadCount.setCount(0);
                            loadCounts.add(downLoadCount);
                        }
                    }
                }
            }
        }
        return loadCounts;
    }

    @Override
    public ServerResponse downloadCount(DownLoadCount downLoadCount) {
        //统计下载次数
        int count = 1;
        if(downLoadCount.getCount() != null){
            count = downLoadCount.getCount() + 1;
        }
        downLoadCount.setCount(count);
        downLoadCountDao.save(downLoadCount);
        return ServerResponse.success();
    }

}
