package com.zjty.efs.bus.controller;

import com.zjty.efs.bus.entity.Attention;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.bus.service.AttentionService;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

@AutoDocument
@Api(tags = "提醒接口")
@RestController
@RequestMapping("/attention")
@Slf4j
public class AttentionController {
    @Autowired
    AttentionService attentionService;
    @ApiOperation(value = "获取提醒列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "当前登录用户", dataType = "String", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageNum", value = "页码", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageSize", value = "条数", dataType = "int", paramType = "query", required = true)
    })
    @GetMapping("/getAttention")
    public ResponseEntity<Paging<Attention>> getAttentionList(@RequestParam String userId, int pageNum, int pageSize){
        log.info("获取提醒列表:{}", userId);
        return ResponseEntity.ok(attentionService.getAttentionList(userId, pageNum, pageSize));
    }

    @ApiOperation(value = "修改提醒为已读")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "attentions", value = "提醒实体", paramType = "body", dataType = "Attention",
                    required = true, allowMultiple = true)
    })
    @PutMapping("/updateStatus")
    public ResponseEntity updateStatus(@RequestBody @Valid List<Attention> attentions){
        log.info("修改提醒为已读");
        return ResponseEntity.ok(attentionService.updateStatus(attentions));
    }

    @ApiOperation(value = "消息提醒小红点")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "当前用户", paramType = "query", dataType = "String", required = true)
    })
    @GetMapping("/redDot")
    public ResponseEntity getRedDot(@RequestParam String userId){
        log.info("消息提醒小红点");
        return ResponseEntity.ok(attentionService.getRedDot(userId));
    }

}
