package com.zjty.efs.bus.service;

import com.alibaba.fastjson.JSONObject;
import com.zjty.efs.bus.entity.Notice;


public interface NoticeService {
    /**
     * 新增通知
     * @param jsonObject 通知json对象
     * @return
     */
    String addNotice(Notice jsonObject);

    /**
     * 修改通知
     * @param jsonObject 通知json对象
     * @return
     */
    String updateNotice(Notice jsonObject);

    /**
     * 查看通知
     * @param id
     * @return
     */
    String getNotice(int id);

    /**
     * 获取通知列表
     * @param user 登录用户
     *
     *  type 通知类型  接受 0，发送 1，草稿 2
     *
     * @return 通知json对象
     */
    String getReceiveList(String user, int type);


}
