package com.zjty.efs.ftp.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

@AutoDocument
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "文件存储",description = "将文件信息存储在数据库中")
public class FileSave {
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @ApiModelProperty(value = "id",notes = "文件id",example = "1")
    private Integer id;//文件id
    @ApiModelProperty(value = "realName",notes = "文件真正存储名称",example = "1(1).zip")
    private String realName;//真实名称
    @ApiModelProperty(value = "fileName",notes = "文件传入名称",example = "1.zip")
    private String fileName;//传入名称
    @ApiModelProperty(value = "path",notes = "文件真正存储路径",example = "/file/uploads/1(1).zip")
    private String path;//文件存储路径
}
