package com.zjty.efs.bus.util;

import com.zjty.efs.bus.entity.Attention;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.service.AttentionService;
import com.zjty.efs.bus.service.NoticeService;
import com.zjty.efs.ftp.entity.DownLoadCount;
import com.zjty.efs.ftp.entity.DownLoadRequest;
import com.zjty.efs.ftp.service.DownLoadService;
import lombok.extern.log4j.Log4j;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Component
@Slf4j
public class Job {
    @Autowired
    NoticeService noticeService;
    @Autowired
    AttentionService attentionService;
    @Autowired
    DownLoadService downLoadService;
    @Scheduled(cron = "0 */1 * * * ?")
    public void cronJob() {

        try {
            Date now = new Date();

            List<Notice> noticeList = noticeService.findBySender("",0,0);
            for(Notice notice:noticeList){

                Date endTime = notice.getDeadline();
                //失效天数
                double days = (endTime.getTime()-now.getTime())/(1000*3600*24.0);
//                System.out.println(days);

//                updateAtt(notice, days, 1);
                if (days <= 3.001 && days > 2.998 && notice.getLabel() != 1){
                    updateAtt(notice, "3", 1);
                }
                if(days <= 1.001 && days > 0.998 && notice.getLabel() != 2){
                    updateAtt(notice, "1", 2);
                }
            log.info("定时任务：消息提醒");
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    /**
     * 判断是否有已读未下载的文件
     * @param notice　通知
     * @param days　失效天数
     * @param label　修改通知label 1为提醒过一次，２为提醒过两次
     */
    private void updateAtt(Notice notice, String days, int label){
        String data = "";
        Attention attention = new Attention();
//        data = "您收到来自["+ notice.getUnit() + "][" + notice.getName() +"]标题为[" + notice.getTitle() + "]的通知,没有查看";
        if (!"".equals(notice.getFileList())){
            //文件列表不为空
            String file = notice.getFileList();
            String[] files = file.split(",");
            List<Integer> fileList = new ArrayList<>();
            DownLoadRequest downLoadRequest = new DownLoadRequest();
            for(int i = 0; i < files.length; i++){
                String s = files[i];
                fileList.add(Integer.parseInt(s));
            }
            downLoadRequest.setFileIds(fileList);
            downLoadRequest.setUserId(notice.getReceiver());

            List<DownLoadCount> downLoadCounts = downLoadService.findCount(downLoadRequest);
//            System.out.println(downLoadCounts);
            for(DownLoadCount downLoadCount:downLoadCounts){
                if(downLoadCount.getCount() == 0){
                    data = "您收到["+ notice.getUnit() + "_" + notice.getName() +"]的《" + notice.getTitle() + "》,有文件没有下载";
                    add(days, attention, data, notice, label);
                }
            }


        }
//        else {
//            add(days, attention, data, notice, label);
//        }

    }

    /**
     * 新增提醒，并修改通知label
     * @param days 失效天数
     * @param attention　提醒实体
     * @param data　提醒内容
     * @param notice　通知实体
     * @param label　该通知提醒过几次
     */
    private void add(String days, Attention attention, String data, Notice notice, int label){
//        int d = (int)Math.ceil(days);
        data = data + ",还有" + days + "天失效。请尽快下载。";
        attention.setData(data);
        attention.setNoticeId(notice.getId());

//        String str = notice.getAddressee();
//        List<Addressee> addresseeList = JSONArray.parseArray(str,Addressee.class);
//        String userId = addresseeList.get(0).getId();
        attention.setUserId(notice.getReceiver());
        attention.setStatus(0);
        attention.setUpdateTime(new Date());
        attentionService.addAttention(attention);
        notice.setLabel(label);
        noticeService.saveNotice(notice);
    }

}
