package com.zjty.efs.bus.service;

import com.alibaba.fastjson.JSONObject;
import com.zjty.efs.bus.entity.Notice;
import org.springframework.data.domain.Page;

import java.util.List;


public interface NoticeService {
    /**
     * 新增通知
     * @param jsonObject 通知对象
     * @return
     */
    boolean addNotice(Notice jsonObject);

    /**
     * 修改通知
     * @param jsonObject 通知对象
     * @return
     */
    boolean updateNotice(Notice jsonObject);

    /**
     * 查看通知
     * @param id 通知id
     * @return
     */
    Notice getNotice(int id);

    /**
     * 获取通知列表
     * @param user 登录用户
     *
     *  type 通知类型  接受 0，发送 1，草稿 2
     *
     * @return 通知json对象
     */
    Page<Notice> getReceiveList(int user, int type, int pageNum, int pageSize);

    /**
     * 修改通知为已读
     * @param notices 需要修改的通知实体列表
     */
    boolean updateStatus(List<Notice> notices);


}
