package com.zjty.efs.bus.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zjty.efs.bus.Dao.NoticeDao;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.service.NoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class NoticeServiceImpl implements NoticeService {
    @Autowired
    NoticeDao noticeDao;


    @Override
    public boolean addNotice(Notice notice) {
        try{
            noticeDao.save(notice);
            notice.setType(0);
            noticeDao.save(notice);
            return true;

        }catch (Exception e){
            e.printStackTrace();
            return false;
        }

    }

    @Override
    public boolean updateNotice(Notice notice) {
        try{
            noticeDao.save(notice);
            return true;

        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Notice getNotice(int id) {
        try {
            return noticeDao.findById(id);
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }

    @Override
    public Page<Notice> getReceiveList(int user, int type, int pageNum, int pageSize) {

        Pageable pageable = PageRequest.of(pageNum - 1, pageSize, Sort.Direction.DESC,"updateTime");
        Page<Notice> p = noticeDao.findOutBySenderAndType(user, type, pageable);
        return p;
    }

    @Override
    public boolean updateStatus(List<Notice> notices) {
        try {
            for (Notice notice:notices){
                noticeDao.save(notice);
            }
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }
}
