package com.zjty.efs.ftp.controller;

import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.entity.DownLoadCount;
import com.zjty.efs.ftp.service.FileDownLoadService;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@AutoDocument
@RestController
@RequestMapping("/file")
@Api(tags = "文件下载",description = "文件下载")
public class FileDownLoadController {
    @Autowired
    private FileDownLoadService fileDownLoadService;

    @GetMapping("/download/{fileName}")
    @ApiOperation(value = "文件下载",notes = "通过文件名称下载文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "fileName",value = "文件名称",paramType = "query",example = "1.zip",required = true),
            @ApiImplicitParam(name = "response",value = "响应对象",paramType = "query",required = true),
            @ApiImplicitParam(name = "request",value = "请求对象",paramType = "query",required = true),
    })
    public void fileDownLoad(@PathVariable("fileName") String fileName, HttpServletResponse response, HttpServletRequest request){
        fileDownLoadService.fileDownLoad(fileName,response,request);
    }

}
