package com.zjty.efs.ftp.service.impl;

import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.entity.FileReturn;
import com.zjty.efs.ftp.service.FileUploadService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Service
@Slf4j
public class FileUploadServiceImpl implements FileUploadService {

    @Value("${file.address}")
    private String fileAddress;

    /**
     * 前台文件上传
     * @param request
     * @return
     */
    @Override
    public ServerResponse fileUpload(HttpServletRequest request) {
        List<MultipartFile> multipartFiles = ((MultipartHttpServletRequest)request).getFiles("file");
        List<FileReturn> fileReturns = new ArrayList<>();
        if(multipartFiles != null && multipartFiles.size() != 0){
            for(MultipartFile multipartFile:multipartFiles){
                InputStream is = null;
                BufferedInputStream bis = null;
                FileOutputStream fos = null;
                BufferedOutputStream bos = null;
                FileReturn fileReturn = new FileReturn();
                String sourceName = multipartFile.getOriginalFilename();
                String suffix = sourceName.substring(sourceName.lastIndexOf("."));
                String fileName = UUID.randomUUID().toString() + suffix;
                //不存在该目录，创建目录
                File file = new File(fileAddress);
                if(!file.exists()){
                    file.mkdirs();
                }
                String savePath = file.getAbsolutePath() + "/" + fileName;
                File createFile = new File(savePath);
                try {
                    is = multipartFile.getInputStream();
                    bis = new BufferedInputStream(is);
                    fos = new FileOutputStream(createFile);
                    bos = new BufferedOutputStream(fos);
                    int len = -1;
                    byte[] b = new byte[1024];
                    while ((len = bis.read(b)) != -1){
                        bos.write(b,0,len);
                    }
                    fileReturn.setName(sourceName);
                    fileReturn.setPath(savePath);
                    fileReturns.add(fileReturn);
                } catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }finally {
                    try {
                        bis.close();
                        is.close();
                        bos.close();
                        fos.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }else {
            log.info("上传失败，请重新确定key值，重新上传");
            return ServerResponse.error("上传失败，请重新确定key值，重新上传");
        }
        return ServerResponse.success(fileReturns);
    }
}
