package com.zjty.efs.union.config;

import com.zjty.efs.misc.util.MD5Untils;
import com.zjty.efs.user.subject.dao.UserDao;
import com.zjty.efs.user.subject.entity.UserDo;
import com.zjty.efs.user.subject.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import sun.security.provider.MD5;

import java.util.Date;
import java.util.List;

/**
 *
 * user 模块初始化admin
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-30
 */
@Slf4j
@Component
public class UserInit implements CommandLineRunner {

    @Autowired
    private UserService userService;
    @Autowired
    private UserDao userDao;

    @Override
    public void run(String... args) throws Exception {
//        log.info("删除现有admin账户信息");
//        userDao.deleteUserDosByAccount("admin");
        List<UserDo> rs = userDao.findByAccount("admin");


        if (rs.isEmpty()) {
            userDao.save(new UserDo(null, "admin","123","admin","admin","admin","admin","admin",MD5Untils.getMD5Str("admin"),1,"admin",new Date()));
            return;
        }
        UserDo admin = rs.get(0);
        log.info("初始化amdin账户");
        admin.setPassword(MD5Untils.getMD5Str("admin"));
        userDao.save(admin);
        log.info("初始化admin完成,{}", admin.toString());
    }
}
