package com.zjty.efs.bus.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Generated;
import lombok.NoArgsConstructor;


import javax.persistence.*;
import java.util.Date;


/**
 * 通知表
 */
@AutoDocument
//@ApiModel(value = "通知", description = "通知实体类")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@Table(name = "notice")
public class Notice {
    /**
     * id
     */
    @ApiModelProperty(value = "id", example = "1")
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private int id;

    /**
     * 标题
     */
    @ApiModelProperty(value = "title", example = "验收通知", dataType = "String", name = "标题")
    @Column(name = "title")
    private String title;

    /**
     * 收件人
     */
    @ApiModelProperty(value = "addressee", example = "1", dataType = "String", name = "收件人")
    @Column(name = "addressee")
    private String addressee;

    /**
     * 发件人
     */
    @ApiModelProperty(value = "sender", example = "2", dataType = "String", name = "发件人")
    @Column(name = "sender")
    private String sender;

    /**
     * 留言
     */
    @ApiModelProperty(value = "message", example = "尽快完成", dataType = "String", name = "留言")
    @Column(name = "message")
    private String message;

    /**
     * 通知状态　未查看 0，已查看 1，已下载 2
     */
    @ApiModelProperty(value = "status", example = "0", dataType = "int" ,name = "通知状态",
            notes = "未查看 0，已查看 1，已下载 2,默认 0")
    @Column(name = "status")
    private int status;

    /**
     * 通知类型　接受 0，发送 1，草稿 2
     */
    @ApiModelProperty(value = "type", example = "1", dataType = "int", name = "通知类型",
            notes = "接收 0，发送 1，草稿 2，默认　1")
    @Column(name = "type")
    private int type;

    /**
     * 失效时间
     */
    @ApiModelProperty(value = "deadline", name = "通知失效时间")
    @Column(name = "deadline")
    private Date deadline;

    /**
     * 通知更新时间
     */
    @ApiModelProperty(value = "updateTime", name = "通知更新时间")
    @Column(name = "update_time")
    private Date updateTime;

    /**
     * 是否推送短信　是　０，否　１
     */
    @ApiModelProperty(value = "note", example = "0", dataType = "int", name = "是否推送短信")
    @Column(name = "note")
    private int note;

    /**
     * 附件列表
     */
    @ApiModelProperty(value = "fileList", example = "", dataType = "list", name = "附件列表")
    @Column(name = "file_list")
    private String fileList;

}
