package com.zjty.efs.bus.service.impl;

import com.zjty.efs.bus.Dao.NoticeDao;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.bus.service.NoticeService;
import com.zjty.efs.log.subject.entity.EfsLog;
import com.zjty.efs.log.tool.EfsLogUtil;
import com.zjty.efs.user.subject.entity.UserDo;
import com.zjty.efs.user.subject.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.*;

import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class NoticeServiceImpl implements NoticeService {
    @Autowired
    NoticeDao noticeDao;
    @Autowired
    EfsLogUtil efsLogUtil;
    @Autowired
    UserService userService;
    @Override
    public boolean addNotice(Notice notice) {
        try{
            notice.setUpdateTime(new Date());
            notice.setDeadline(new Date());
            noticeDao.save(notice);

            Notice notice1 = new Notice();
            notice1.setType(0);
            notice1.setTitle(notice.getTitle());
            notice1.setAddressee(notice.getAddressee());
            notice1.setDeadline(notice.getDeadline());
            notice1.setFileList(notice.getFileList());
            notice1.setMessage(notice.getMessage());
            notice1.setNote(notice.getNote());
            notice1.setSender(notice.getSender());
            notice1.setStatus(notice.getStatus());
            notice1.setUpdateTime(notice.getUpdateTime());
            noticeDao.save(notice1);
            System.out.println(notice.getSender() + notice.getAddressee());
            UserDo userDo = userService.findById(notice.getSender()); // 发送人
            UserDo userDo1 = userService.findById(notice.getAddressee()); //接收人

            String data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                    + "]给[" + userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
                    + "发送了关于[" + notice.getTitle() + "的通知";

            String data1 = "[" +userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
                    + "]收到了来自[" + userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                    + "关于[" + notice.getTitle() + "的通知";
            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));
            efsLogUtil.addLog(new EfsLog(null, userDo1.getId(), data1, new Date()));

            return true;

        }catch (Exception e){
            e.printStackTrace();
            return false;
        }

    }

    @Override
    public boolean updateNotice(Notice notice) {
        try{
            notice.setStatus(0);
            noticeDao.save(notice);
            return true;

        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Notice getNotice(int id) {
        try {
            Notice notice = noticeDao.findById(id);
            notice.setStatus(1);
            noticeDao.save(notice);
            String userId = "";
            if (notice.getType() == 0){
                //已接收
                userId = notice.getAddressee();
            }else {
                userId = notice.getSender();
            }

            if (notice.getType() == 0){
                //已接收
                userId = notice.getAddressee();
            }else {
                userId = notice.getSender();
            }
            UserDo userDo = userService.findById(userId); // 发送人
            String data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                    + "查看了关于[" + notice.getTitle() + "的通知";
            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));
            return notice;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }

    @Override
    public Paging<Notice> getReceiveList(String user, int type, int pageNum, int pageSize) {

        Pageable pageable = PageRequest.of(pageNum - 1, pageSize, Sort.Direction.DESC,"updateTime");
        Page<Notice> p;

        if (type == 0){
            //已接收
            p = noticeDao.findOutByAddresseeAndType(user, type, pageable);
        }else {
            //已发送，草稿
            p = noticeDao.findOutBySenderAndType(user, type, pageable);
        }

        Paging<Notice> paging = new Paging<>();
        paging.setData(p.getContent());
        paging.setPageSize(pageSize);
        paging.setPageNum(pageNum);
        paging.setTotal((int)p.getTotalElements());
        return paging;
    }

    @Override
    public boolean updateStatus(List<Notice> notices) {
        try {
            String userId = "";
            if (notices.get(0).getType() == 0){
                userId = notices.get(0).getAddressee();
            }else {
                userId = notices.get(0).getSender();
            }
            UserDo userDo = userService.findById(userId); // 发送人
            String data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                    + "修改";
            for (Notice notice:notices){
                noticeDao.save(notice);
                data = data + "[" + notice.getTitle() + "]";
            }
            data = data + "为已读";


            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Notice> findBySender(String userId, int status, int type) {
        try{
            return noticeDao.findOutByStatusAndType(status, type);
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }
    }


}
