package com.zjty.efs.bus.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zjty.efs.bus.Dao.AttentionDao;
import com.zjty.efs.bus.entity.Attention;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.bus.entity.RedDot;
import com.zjty.efs.bus.service.AttentionService;
import com.zjty.efs.bus.service.NoticeService;
import com.zjty.efs.bus.service.ReddotService;
import com.zjty.efs.bus.websocket.WebSocketServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class AttentionServiceImpl implements AttentionService {
    @Autowired
    AttentionDao attentionDao;
    @Autowired
    WebSocketServer webSocketServer;
    @Autowired
    ReddotService reddotService;

    @Override
    public Paging<Attention> getAttentionList(String userId, int pageNum, int pageSize, int staus) {
        try {
            Pageable pageable = PageRequest.of(pageNum - 1, pageSize, Sort.Direction.DESC,"updateTime");
            Page<Attention> p;
            if (staus ==2 ){
                p = attentionDao.findOutByUserId(userId, pageable);
            }else {
                p = attentionDao.findOutByUserIdAndStatus(userId, pageable, staus);
            }


            Paging<Attention> paging= new Paging<>();
            paging.setTotal((int)p.getTotalElements());
            paging.setPageNum(pageNum);
            paging.setPageSize(pageSize);
            paging.setData(p.getContent());
            return paging;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }

    @Override
    @Transactional
    public boolean addAttention(Attention attention) {
        try{
            attentionDao.save(attention);
            sendMessage(attention.getUserId());
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @Transactional
    public boolean updateStatus(List<Attention> attentions) {
        try{
            String userId = "";
            for(Attention attention:attentions){
                userId = attention.getUserId();
                attention.setStatus(1);
                attentionDao.save(attention);
            }
            sendMessage(userId);
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }

    }

    @Override
    public int getRedDot(String userId) {
        List<Attention> attentions = attentionDao.findOutByUserIdAndStatus(userId, 0);
        return attentions.size();
    }

    @Override
    public void sendMessage(String userId){
        int attentionNum = attentionDao.findOutByUserIdAndStatus(userId,0).size();
        RedDot redDot1 = reddotService.findByUserId(userId);
        if (redDot1 == null){
            redDot1 = new RedDot();
        }
        redDot1.setAttention(attentionNum);
        reddotService.addReddot(redDot1);
        webSocketServer.sendData(userId, JSONObject.toJSONString(redDot1));
    }

}
