package com.zjty.efs.ftp.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

@AutoDocument
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@ApiModel(value = "FileSave",description = "将文件信息存储在数据库中")
public class FileSave {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(name = "id",value = "文件id",notes = "文件id",example = "1")
    private Integer id;//文件id
    @ApiModelProperty(name = "realName",value = "文件真正存储名称",notes = "文件真正存储名称",example = "1(1).zip")
    private String realName;//真实名称
    @ApiModelProperty(name = "fileName",value = "文件传入名称",notes = "文件传入名称",example = "1.zip")
    private String fileName;//传入名称
    @ApiModelProperty(name = "path",value = "文件真正存储路径",notes = "文件真正存储路径",example = "/file/uploads/1(1).zip")
    private String path;//文件存储路径
    @ApiModelProperty(name = "fileSize",value = "文件大小",notes = "文件大小",example = "973kb")
    private String fileSize;//文件大小
    @ApiModelProperty(name = "suffix",value = "文件名后缀",notes = "文件名后缀",example = "png")
    private String suffix;//文件名后缀
    @ApiModelProperty(name = "prefix",value = "文件名前缀",notes = "文件名前缀",example = "1")
    private String prefix;//文件名前缀
}
