package com.zjty.efs.ftp.service.impl;

import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.dao.FileSaveDao;
import com.zjty.efs.ftp.service.FileSaveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class FileSaveServiceImpl implements FileSaveService {
    @Autowired
    private FileSaveDao fileSaveDao;

    @Override
    public ServerResponse getFiles(List<Integer> idList) {
        return ServerResponse.success(fileSaveDao.findByIdIn(idList));
    }

    @Override
    public ServerResponse findIdByName(String fileName) {
        return ServerResponse.success(fileSaveDao.findIdByFileName(fileName));
    }
}
