package com.zjty.efs.user.subject.service;

import com.zjty.efs.user.subject.entity.*;

import java.util.List;

/**
 * 提供给前端的方法
 *
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-24
 */
public interface UserService {

    /**
     * 更新内容
     * @param userDo
     * @return
     */
    UserDo update(UserDo userDo);

    /**
     * 根据id查找
     * @param id user id
     * @return user obj
     */
    UserDo findById(String id);

    /**
     * 查找所用用户，除了管理员
     * @return users obj
     */
    UserVo findAllUser(String id, Integer page, Integer size);

    /**
     * 更新人员状态
     * 1，正常 2，冻结
     * @return true 成功 false 失败
     */
    Boolean updateUserStatus(String id, Integer status);

    /**
     * 查询可以发布消息的人员
     * 需除去admin及自己
     * @param id 人员id
     * @return users obj
     */
    List<NameListVo> getAllowAckUser(String id);

    /**
     * 重置密码
     * @param id 人员id
     * @param pwd 重置的密码
     * @return true 成功 false 失败
     */
    UserDo resetPassword(String id, String pwd);

    /**
     * 创建用户
     * @param userDo 用户对象
     * @return true or false
     */
    UserDo addUser(UserDo userDo);

    /**
     * 根据用户和密码登陆
     * @param username
     * @param password
     * @return
     */
    UserDo login(String username, String password);

    /**
     * 修改密码
     * @param id
     * @param oPwd
     * @param nPwd
     * @return
     */
    UserDo updatePwd(String id, String oPwd, String nPwd);


    /**
     * 查找所有部门
     * @return 部门集合
     */
    List<Unit> findUnit();

    /**
     * 根据单位查找用户
     * @param unit 单位名称
     * @return obj
     */
    List<UnitMemVo> findByUnit(String unit);

    /**
     * 查找单位及用户
     * @param id 当前用户id
     * @return
     */
    List<DepUser> findDepUserI(String id);

    /**
     * 查找单位及用户
     * @param id 当前用户id
     * @return
     */
    List<DepUser> findDepUserII(String id);

}
