package com.zjty.efs.ftp.controller;

import com.zjty.efs.ftp.base.response.ServerResponse;
import com.zjty.efs.ftp.service.FileSaveService;
import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@AutoDocument
@RestController
@RequestMapping("/file")
@Api(tags = "文件存储",description = "对存储在数据库中文件信息的操作")
public class FileSaveController {
    @Autowired
    private FileSaveService fileSaveService;

    @PutMapping("/findById")
    @ApiOperation(value = "文件查询",notes = "通过文件id查询文件信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "idList",value = "文件id集合",paramType = "query",example = "[1,2]",required = true)
    })
    public ServerResponse findById(@RequestBody List<Integer> idList){
        return fileSaveService.getFiles(idList);
    }

    @GetMapping("/findIdByName")
    @ResponseBody
    public ServerResponse findIdByFileName(@RequestParam(value = "fileName") String fileName){
        return fileSaveService.findIdByName(fileName);
    }
}

