package com.zjty.efs.log.subject.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.util.Date;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-26
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@AutoDocument
@ApiModel(value = "消息日志", description = "消息模块")
@Entity
public class EfsLog {

    @ApiModelProperty(value = "id",example = "jksdhfjks5")
    @Id
    @GeneratedValue(generator = "uuid2")
    @GenericGenerator(name = "uuid2", strategy = "org.hibernate.id.UUIDGenerator" )
    private String id;

    @ApiModelProperty(value = "操作人id", example = "张三")
    private String operatorId;

    @ApiModelProperty(value = "消息内容",example = "***干了***")
    private String msg;

    @ApiModelProperty(value = "创建时间",example = "2010-01-01 00:00:00")
    private Date time;
}
