package com.zjty.efs.user.subject.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "人员集合返回值")
public class UserVo {

    @ApiModelProperty(value = "总数", example = "100")
    private int total;

    @ApiModelProperty(value = "当前页，从1开始", example = "1")
    private int page;

    @ApiModelProperty(value = "每页大小", example = "10")
    private int size;

    @ApiModelProperty(value = "人员对象")
    List<UserDo> data;
}
