package com.zjty.efs.bus.Dao;

import com.zjty.efs.bus.entity.Notice;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface NoticeDao extends JpaRepository<Notice , Integer> {
    Notice findById(int id);
    Page<Notice> findOutBySenderAndType(String sender, int type, Pageable pageable);
    Page<Notice> findOutByAddresseeLikeAndType(String addressee, int type, Pageable pageable);
    List<Notice> findOutByTypeAndLabelNot(int type, int label);
    Page<Notice> findOutByAddresseeLikeAndTypeAndStatus(String addressee, int type, int status, Pageable pageable);
    Page<Notice> findOutByReceiverAndType(String addressee, int type, Pageable pageable);
    Page<Notice> findOutByReceiverAndTypeAndStatus(String addressee, int type, int status, Pageable pageable);
    List<Notice> findOutByReceiverAndStatus(String receiver, int status);
    Page<Notice> findOutBySenderAndTypeAndDeleted(String sender, int type, Pageable pageable, String deleted);

}
