package com.zjty.efs.ftp.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.web.multipart.MultipartFile;

@AutoDocument
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "UploadRequest",description = "文件上传请求体")
public class UploadRequest {
    @ApiModelProperty(name = "multipartFile",value = "文件数据",notes = "文件数据")
    private MultipartFile multipartFile;//文件
    @ApiModelProperty(name = "md5File",value = "MD5生成的文件夹名称",notes = "MD5生成的文件夹名称",example = "fc44454f994403b01b40895f0a6535b5")
    private String md5File;//md5文件
    @ApiModelProperty(name = "chuck",value = "当前分片",notes = "当前分片",example = "1")
    private Integer chuck;//分片
}
