package com.zjty.efs.user.subject.controller;

import com.zjty.efs.misc.config.AutoDocument;
import com.zjty.efs.user.subject.entity.UserDo;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-24
 */
@RestController
@RequestMapping("/api")
@AutoDocument
@Api(tags = "用户模块接口")
@Slf4j
public class UserController {

    @GetMapping("/user")
    @ApiOperation(value = "查询用户的接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="id",dataType="string", paramType = "query")
    })
    public ResponseEntity<UserDo> getUserById(@RequestParam(value = "id") String id) {
        log.info("查询id:{}", id);
        return ResponseEntity.ok(new UserDo());
    }

    @GetMapping("/otherUser")
    @ApiOperation(value = "获取相关人员信息接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="string", paramType = "query")
    })
    public ResponseEntity<List<UserDo>> getAllUser(@RequestParam(value = "id") String id) {
        List<UserDo> list = new ArrayList<>();
        list.add(new UserDo());
        return ResponseEntity.ok(list);
    }

    @PutMapping("/reset")
    @ApiOperation(value = "重置用户密码")
    @ApiImplicitParams({
            @ApiImplicitParam(name="id",value="人员id",dataType="string", paramType = "query")
    })
    public ResponseEntity resetStatus(@RequestParam(value = "id") String id) {

        return ResponseEntity.ok(true);
    }

}
