package com.zjty.efs.bus.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zjty.efs.bus.Dao.NoticeDao;
import com.zjty.efs.bus.entity.Addressee;
import com.zjty.efs.bus.entity.Attention;
import com.zjty.efs.bus.entity.Notice;
import com.zjty.efs.bus.entity.Paging;
import com.zjty.efs.bus.service.AttentionService;
import com.zjty.efs.bus.service.NoticeService;
import com.zjty.efs.log.subject.entity.EfsLog;
import com.zjty.efs.log.tool.EfsLogUtil;
import com.zjty.efs.user.subject.entity.UserDo;
import com.zjty.efs.user.subject.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Transient;
import org.springframework.data.domain.*;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


import java.lang.reflect.Array;
import java.util.*;

@Service
@Slf4j
public class NoticeServiceImpl implements NoticeService {
    @Autowired
    NoticeDao noticeDao;
    @Autowired
    EfsLogUtil efsLogUtil;
    @Autowired
    UserService userService;
    @Autowired
    AttentionService attentionService;

    @Override
    @Transactional
    public boolean addNotice(Notice notice){
        try{
            UserDo userDo = userService.findById(notice.getSender()); // 发送人用户
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DATE, 7);
            String[] strings = notice.getAddressee().split(",");
            notice.setUpdateTime(new Date());
            notice.setDeadline(calendar.getTime());
            notice.setUnit(userDo.getUnit());
            notice.setStatus(0);
            notice.setName(userDo.getName());
            notice.setLabel(0);



            if (notice.getType() == 2){
                //保存为草稿
                List<Addressee> addresseeList = new ArrayList<>();
                for(String addressee:strings){
                    UserDo userDo1 = userService.findById(addressee);
                    Addressee addressee1 = new Addressee();//收件人
                    addressee1.setId(userDo1.getId());
                    addressee1.setName(userDo1.getName());
                    addresseeList.add(addressee1);


                }
                notice.setAddressee(JSONObject.toJSONString(addresseeList));
                noticeDao.save(notice);

            }else {
                List<Addressee> addresseeList2 = new ArrayList<>();   //接受者显示的接收列表
                Notice notice1 = transform(notice);  //发送通知
                String dataList = "";
                List<String> stringList = new ArrayList<>();
                for(String addressee:strings){

                    UserDo userDo1 = userService.findById(addressee);   //收件人用户
                    Addressee addressee1 = new Addressee();
                    addressee1.setId(userDo1.getId());
                    addressee1.setName(userDo1.getName());
                    addressee1.setUnit(userDo1.getUnit());
                    addresseeList2.add(addressee1);

                    String data2 = "[" +userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
                            + "]收到了来自[" + userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                            + "]关于[" + notice.getTitle() + "的通知";
                    stringList.add(addressee);

                    dataList = dataList + "[" + userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
                            + "] ";

                    efsLogUtil.addLog(new EfsLog(null, userDo1.getId(), data2, new Date()));

                }

                String add2 = JSONObject.toJSONString(addresseeList2);
                for (String add:stringList){
                    Notice notice2 = transform(notice);  // 接收通知
                    notice2.setAddressee(add2);
                    notice2.setType(0);
                    notice2.setReceiver(add);
                    noticeDao.save(notice2);

                    UserDo userDo1 = userService.findById(add);   //收件人用户

                    String data2 = "[" +userDo1.getUnit() + "][" + userDo1.getDepartment() + "]的[" + userDo1.getName()
                            + "]收到了来自[" + userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                            + "]关于[" + notice.getTitle() + "的通知";

                    Attention attention = new Attention();
                    attention.setStatus(0);
                    attention.setUpdateTime(new Date());
                    attention.setData(data2);
                    attention.setUserId(add);
                    attentionService.addAttention(attention);

                }

                notice1.setAddressee(add2);
                noticeDao.save(notice1);
                String data1 = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                        + "]给"  + dataList
                        + "发送了关于[" + notice.getTitle() + "]的通知";

                Attention attention = new Attention();
                attention.setStatus(0);
                attention.setNoticeId(notice1.getId());
                attention.setUpdateTime(new Date());
                attention.setData(data1);
                attention.setUserId(userDo.getId());
                attentionService.addAttention(attention);
                efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data1, new Date()));

            }
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }

    }

    private Notice transform(Notice notice){
        Notice notice1 = new Notice();
        notice1.setId(notice.getId());
        notice1.setTitle(notice.getTitle());
        notice1.setAddressee(notice.getAddressee());
        notice1.setDeadline(notice.getDeadline());
        notice1.setFileList(notice.getFileList());
        notice1.setMessage(notice.getMessage());
        notice1.setNote(notice.getNote());
        notice1.setSender(notice.getSender());
        notice1.setStatus(notice.getStatus());
        notice1.setUpdateTime(notice.getUpdateTime());
        notice1.setType(notice.getType());
        notice1.setUnit(notice.getUnit());
        notice1.setName(notice.getName());
        notice1.setLabel(notice.getLabel());
        return notice1;
    }

    @Override
    @Transactional
    public boolean updateNotice(Notice notice) {
        try{
            notice.setStatus(0);
            noticeDao.save(notice);
            return true;

        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @Transactional
    public Notice getNotice(int id, String userId) {
        try {
            Notice notice = noticeDao.findById(id);
            notice.setStatus(1);
            noticeDao.save(notice);
            UserDo userDo = userService.findById(userId); // 当前用户
            String data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                    + "查看了关于[" + notice.getTitle() + "的通知";
            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));

            return notice;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }

    @Override
    public Paging<Notice> getReceiveList(String user, int type, int pageNum, int pageSize) {
        try{
            Pageable pageable = PageRequest.of(pageNum - 1, pageSize, Sort.Direction.DESC,"updateTime");
            Page<Notice> p;

            if (type == 0){
                //已接收
//                p = noticeDao.findOutByAddresseeLikeAndType("%"+user+"%", type, pageable);
                p = noticeDao.findOutByReceiverAndType(user, type,pageable);
            }else {
                //已发送，草稿
                p = noticeDao.findOutBySenderAndType(user, type, pageable);
            }

//        for (Notice notice:p.getContent()){
//            String addresseeId = "";//收件人编号
//            UserDo addressee = new UserDo();//收件人实体
//            for (int i = 0; i < p.getContent().size(); i++){
//                List<Addressee> addressees = new ArrayList<>();
//                Notice notice = p.getContent().get(i);
//                if (i == 0) {
//                    addresseeId = notice.getAddressee().split(",")[0];
//                    addressee = userService.findById(addresseeId);
//                }else {
//                    String addresseeId1 = notice.getAddressee().split(",")[0];
//                    if (!addresseeId.equals(addresseeId1)){
//                        //如果两个收件人不一样，重新获取user
//                        addressee = userService.findById(addresseeId1);
//                    }
//                }
//
//                Addressee addressee1 = new Addressee();
//                addressee1.setId(addressee.getId());
//                addressee1.setName(addressee.getName());
//                addressees.add(addressee1);
//                String json = JSONObject.toJSONString(addressees);
//                notice.setAddressee(json);
//            }


            Paging<Notice> paging = new Paging<>();
            paging.setData(p.getContent());
            paging.setPageSize(pageSize);
            paging.setPageNum(pageNum);
            paging.setTotal((int)p.getTotalElements());
            return paging;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }


    }

    @Override
    @Transactional
    public boolean updateStatus(List<Notice> notices, String userId) {
        try {
//            String userId = "";
//            if (notices.get(0).getType() == 0){
//                String str = notices.get(0).getAddressee();
//                List<Addressee> addresseeList = JSONArray.parseArray(str,Addressee.class);
//                userId = addresseeList.get(0).getId();
//            }else {
//                String str = notices.get(0).getSender();
//                Addressee addressee = JSONObject.parseObject(str,Addressee.class);
//                userId = addressee.getName();
//            }
            UserDo userDo = userService.findById(userId); // 当前登录人
            String data = "[" +userDo.getUnit() + "][" + userDo.getDepartment() + "]的[" + userDo.getName()
                    + "修改";
            for (Notice notice:notices){
                notice.setStatus(1);
                noticeDao.save(notice);
                data = data + "[" + notice.getTitle() + "]";
            }
            data = data + "为已读";


            efsLogUtil.addLog(new EfsLog(null, userDo.getId(), data, new Date()));
            return true;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Notice> findBySender(String userId, int status, int type) {
        try{
            return noticeDao.findOutByStatusAndTypeAndLabel(status, type, 0);
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void saveNotice(Notice notice) {
        noticeDao.save(notice);
    }

    @Override
    public Paging<Notice> getListByStatus(String user, int status, int pageNum, int pageSize,int type) {
        try{
            Pageable pageable = PageRequest.of(pageNum - 1, pageSize, Sort.Direction.DESC,"updateTime");
            Page<Notice> p = noticeDao.findOutByReceiverAndTypeAndStatus(user,type, status, pageable);
//            Page<Notice> p = noticeDao.findOutByAddresseeLikeAndTypeAndStatus("%"+user+"%",type, status, pageable);
            Paging<Notice> paging = new Paging<>();
            paging.setData(p.getContent());
            paging.setPageSize(pageSize);
            paging.setPageNum(pageNum);
            paging.setTotal((int)p.getTotalElements());
            return paging;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }


}
