package com.zjty.efs.bus.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
@AutoDocument
@ApiModel(value = "分页")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Paging<T> {
    @ApiModelProperty(value = "total", example = "12", dataType = "int", name = "总数")
    private int total;
    @ApiModelProperty(value = "pageSize", example = "10", dataType = "int", name = "每页条数")
    private int pageSize;
    @ApiModelProperty(value = "pageNum", example = "1", dataType = "int", name = "页码", notes = "从1开始")
    private int pageNum;
    @ApiModelProperty(value = "data", example = "")
    List<T> data;
}
