package com.zjty.efs.log.subject.entity;

import com.zjty.efs.misc.config.AutoDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-26
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@AutoDocument
@ApiModel(value = "查询日志返回类", description = "返回对象")
public class EfsLogVo {

    @ApiModelProperty(value = "总数", example = "10")
    private Long total;

    @ApiModelProperty(value = "页数", example = "1")
    private Integer page;

    @ApiModelProperty(value = "每页大小", example = "10")
    private Integer size;

    @ApiModelProperty(value = "对象", example = "")
    private List<EfsLog> data;
}
