package com.zjty.efs.log.subject.service.impl;

import com.zjty.efs.log.subject.dao.EfsLogDao;
import com.zjty.efs.log.subject.entity.EfsLog;
import com.zjty.efs.log.subject.entity.EfsLogVo;
import com.zjty.efs.log.subject.service.EfsLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-26
 */
@Service
public class EfsLogServiceImpl implements EfsLogService {

    @Autowired
    private EfsLogDao efsLogDao;

    @Override
    public EfsLogVo findAllLog(Integer page, Integer sze) {
        Pageable pageable = PageRequest.of(page, sze, Sort.Direction.DESC, "time");
        List<EfsLog> rs = efsLogDao.findAll(pageable).getContent();
        return new EfsLogVo(efsLogDao.count(),page,sze,rs);
    }

    @Override
    public Boolean addLog(EfsLog efsLog) {
        efsLogDao.save(efsLog);
        return true;
    }

}
