package com.example.demo3.controller;


import com.example.demo3.pojo.*;
import com.example.demo3.service.CommentService;
import com.example.demo3.service.ConsumerService;
import com.example.demo3.service.PostChildrenService;
import com.example.demo3.service.PostService;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author tykj
 *
 */
@RestController
@RequestMapping("/model2")
@Api(tags = "贴吧平台",description = "贴吧基础接口")
public class Controller {

    @Autowired
    private PostService postService;

    @Autowired
    private ConsumerService consumerService;

    @Autowired
    private CommentService commentService;

    @Autowired
    private PostChildrenService postChildrenService;

    @PostMapping("/saveConsumer")
    @ApiOperation(value = "添加用户")
    public Consumer saveOne(@RequestBody Consumer consumer){
        return consumerService.saveOne(consumer);
    }

    @PostMapping("/savePost")
    @ApiOperation(value = "新建帖子")
    public Post saveOnePost(PostVO postVO){
        return postService.saveOnePost(postVO);
    };

    @GetMapping("/findAll")
    @ApiOperation(value = "查看主页面")
    public PagePojo findAll(Integer page,Integer pageSize){
        return postService.findAll(page,pageSize);
    };

    @GetMapping("/findPost")
    @ApiOperation(value = "查看帖子")
    public Post findById(@RequestParam Integer id){
        return postService.findById(id);
    }

    @PostMapping("/saveComment")
    @ApiOperation(value = "添加评论")
    public Comment saveOne(Comment comment){
        return commentService.saveOne(comment);
    }

    @DeleteMapping("/deleteComment")
    @ApiOperation(value = "删除评论")
    public ResponseEntity deleteComment(Integer id){
           commentService.deleteComment(id);
        return ResponseEntity.status(403).body("删除成功");
    }
    @PostMapping("/savePostChildren")
    @ApiOperation(value = "新建回贴")
    public PostChildren saveOne(PostChildren postChildren){
        return postChildrenService.saveOne(postChildren);
    }

    @DeleteMapping("/deletePostChildren")
    @ApiOperation(value = "删除回帖")
    public ResponseEntity deleteById(Integer integer){
        postChildrenService.deleteById(integer);
        return ResponseEntity.status(403).body("删除成功");
    }

    @PostMapping("findConsumerPost")
    @ApiOperation(value = "查询用户帖子")
    public List<Post> findByConsumerId(Integer consumerId){
        return postService.findByConsumerId(consumerId);
    }



}
