package com.example.demo3.dao;

import com.example.demo3.pojo.Comment;
import com.example.demo3.pojo.PostChildren;
import org.springframework.data.jpa.repository.JpaRepository;

import javax.transaction.Transactional;
import java.util.List;

/**
 * @author tykj
 *
 */
public interface CommentDao extends JpaRepository<Comment,Integer> {

    /**
     * 根据回帖ID获取评论
     * @param postChildrenId
     * @return
     */
    List<Comment> findAllByPostChildrenId(Integer postChildrenId);

    /**
     * 根据ID删除评论
     * @param integer
     */
    @Transactional(rollbackOn = Exception.class)
    void deleteCommentById(Integer integer);

    /**
     * 根据回帖Id删除评论
     * @param integer
     */
    @Transactional(rollbackOn = Exception.class)
    void deleteCommentByPostChildrenId(Integer integer);
}
