package com.example.demo3.dao;

import com.example.demo3.pojo.PostChildren;
import org.springframework.data.jpa.repository.JpaRepository;

import javax.transaction.Transactional;
import java.util.List;

/**
 * @author tykj
 *
 */
public interface PostChildrenDao extends JpaRepository<PostChildren,Integer> {

    /**
     * 根据帖子ID查询回贴
     * @param postId
     * @return List
     */
    List<PostChildren> findAllByPostId(Integer postId);

    /**
     * 根据ID删除回帖
     * @param integer
     */
    @Transactional(rollbackOn = Exception.class)
    void deletePostChildrenById(Integer integer);
}
