package com.example.demo3.pojo;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("主贴显示")
public class PostVO {

    @Id
    @ApiModelProperty(value = "主键ID",example = "1")
    private Integer id;

    @ApiModelProperty(value = "用户ID",example = "2")
    private Integer consumerId;

    @Transient
    @ApiModelProperty(value = "用户姓名",example = "小明")
    private String consumerName;

    @ApiModelProperty(value = "帖子标题",example = "输入一段文字")
    private String title;

    @ApiModelProperty(value = "内容",example = "输入一段文字")
    private String details;

    @ApiModelProperty(value = "时间",example = "2020-1-1")
    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern ="yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
    private Date date;

}
