package com.example.demo3.service.impl;

import com.example.demo3.dao.CommentDao;
import com.example.demo3.pojo.Comment;
import com.example.demo3.service.CommentService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author tykj
 */
@Service
@Slf4j
public class CommentServiceImpl implements CommentService {

    @Autowired
    private CommentDao commentDao;

    @Override
    public Comment saveOne(Comment comment) {
        comment.setDate(new Date());
        return commentDao.save(comment);
    }

    @Override
    public void deleteComment(Integer id) {
        commentDao.deleteCommentById(id);
    }
}
