package com.example.demo3.service.impl;

import com.example.demo3.dao.CommentDao;
import com.example.demo3.dao.PostChildrenDao;
import com.example.demo3.pojo.Comment;
import com.example.demo3.pojo.PostChildren;
import com.example.demo3.service.PostChildrenService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author tykj
 */
@Service
@Slf4j
public class PostChildrenServiceImpl implements PostChildrenService {

    @Autowired
    private PostChildrenDao postChildrenDao;

    @Autowired
    private CommentDao commentDao;


    @Override
    public PostChildren saveOne(PostChildren postChildren) {
        postChildren.setDate(new Date());
        return postChildrenDao.save(postChildren);
    }

    @Override
    public void deleteById(Integer integer) {
        commentDao.deleteCommentByPostChildrenId(integer);
        postChildrenDao.deletePostChildrenById(integer);
    }
}
