package com.example.demo3.service.impl;

import com.example.demo3.dao.CommentDao;
import com.example.demo3.dao.ConsumerDao;
import com.example.demo3.dao.PostChildrenDao;
import com.example.demo3.dao.PostDao;
import com.example.demo3.pojo.*;
import com.example.demo3.service.PostService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;


/**
 * @author tykj
 */
@Service
@Slf4j
public class PostServiceImpl implements PostService {

    @Autowired
    private ConsumerDao consumerDao;

    @Autowired
    private PostDao postDao;

    @Autowired
    private PostChildrenDao postChildrenDao;

    @Autowired
    private CommentDao commentDao;



    @Override
    public Post saveOnePost(PostVO postVO) {
        Post post1 = new Post();
        BeanUtils.copyProperties(postVO,post1);
        post1.setDate(new Date());
        return postDao.save(post1);
    }

    @Override
    public PagePojo findAll(Integer page,Integer pageSize) {
        Page<Post> all = postDao.findAll(PageRequest.of(page, pageSize));
        List<PostVO> postVOList = new ArrayList<>();
        for (Post post : all.getContent()) {
            Integer consumerId = post.getConsumerId();
            Optional<Consumer> byId = consumerDao.findById(consumerId);
            Consumer consumer = null;
            if (byId.isPresent()){
                 consumer = byId.get();
            }
            if (consumer != null){
                post.setConsumerName(consumer.getName());
            }
            //进行属性的复制
            PostVO postVO = new PostVO();
            BeanUtils.copyProperties(post,postVO);
            postVOList.add(postVO);
        }

        PagePojo pagePojo = new PagePojo();
        pagePojo.setPage(page);
        pagePojo.setTotal(all.getTotalElements());
        pagePojo.setPageSize(pageSize);
        pagePojo.setPostVOList(postVOList);
        return pagePojo;
    }

    @Override
    public Post findById(Integer id) {
            Optional<Post> byId = postDao.findById(id);
            Post post =null;
        if (byId.isPresent()){
                post = byId.get();
            }
        List<PostChildren> allByPostId = postChildrenDao.findAllByPostId(id);
            for (PostChildren postChildren : allByPostId){
                Integer consumerId = postChildren.getConsumerId();
                String name = consumerDao.findById(consumerId).get().getName();
                postChildren.setConsumerName(name);
                List<Comment> allByPostChildrenId = commentDao.findAllByPostChildrenId(postChildren.getId());
                for (Comment comment : allByPostChildrenId){
                    Integer consumerId1 = comment.getConsumerId();
                    String name1 = consumerDao.findById(consumerId1).get().getName();
                    comment.setConsumerName(name1);
                }
                postChildren.setComments(allByPostChildrenId);
            }
            if (post != null){
                post.setChildren(allByPostId);
                Optional<Consumer> consumer = consumerDao.findById(post.getConsumerId());
                post.setConsumerName(consumer.get().getName());
            }

        return post;
    }

    @Override
    public List<Post> findByConsumerId(Integer consumerId) {
        return postDao.findByConsumerId(consumerId);
    }


}
