package com.example.train.config;


import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.springframework.web.multipart.MultipartFile;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.info.MultimediaInfo;

import java.io.File;
import java.io.IOException;

/**
 * @author tykj
 */
@Slf4j
public class VideoConfig {
    public static Long getVideoTime(MultipartFile multipartFile)throws IOException{
        //有问题，没有拿到文件路径
        File file = new File(multipartFile.getOriginalFilename());
        FileUtils.copyInputStreamToFile(multipartFile.getInputStream(),file);
        try {
            MultimediaObject instance = new MultimediaObject(file);
            MultimediaInfo result = instance.getInfo();
            long videoTime;
            videoTime =result.getDuration() / 1000;
            file.delete();
            return videoTime;
        }catch (Exception e){
            e.printStackTrace();
        }
        return 0L;
    }


}
