package com.example.train.config;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.springframework.web.multipart.MultipartFile;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.info.MultimediaInfo;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

/**
 * @author tykj
 */
@Slf4j
public class VideoUtil {
    /**
     * 上传视频，获取视频时长，返回毫秒
     * @param url
     * @return
     */
    public static long getDurationBackMillis(String url){
        if(url != null){
            try{
                // 根据上传的文件名字，构建初始化的文件对象（临时文件），这个文件是空的
                File file = new File(url);
//                File file = new File(multipartFile.getOriginalFilename());
                // 通过工具类，将文件拷贝到空的文件对象中
//                FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), file);
                // 将普通文件对象转换为媒体对象
                MultimediaObject multimediaObject = new MultimediaObject(file);
                // 获取媒体对象的信息对象
                MultimediaInfo info = multimediaObject.getInfo();
                // 从媒体信息对象中获取媒体的时长，单位是：ms
                long duration = info.getDuration();
                // 删除临时文件
                file.delete();
                return duration;
            } catch(Exception e){
                log.error(e.toString());
                return 0L;
            }
        }
        return 0L;
    }
    /**
     * 上传视频，获取视频时长，返回时分秒字符串
     * @param url
     * @return
     */
    public static String getDurationBackString(String url){
        // 获取视频时长，返回毫秒
        long duration = getDurationBackMillis(url);
        // 毫秒转时分秒的转换
        // 日期格式化对象，给时分秒格式
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        // 这里很重要，如果不设置时区的话，输出结果就会是几点钟，而不是毫秒值对应的时分秒数量了。
        formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        // 毫秒转化为字符串
        return formatter.format(duration);
    }


    public static File multipartFileToFile(MultipartFile file) throws Exception {
        File toFile = null;
        if (file.equals("") || file.getSize() <= 0) {
            file = null;
        } else {
            InputStream ins = null;
            ins = file.getInputStream();
            toFile = new File(file.getOriginalFilename());
            inputStreamToFile(ins, toFile);
            ins.close();
        }
        return toFile;

    }



    private static void inputStreamToFile(InputStream ins, File file) {
        try {
            OutputStream os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            ins.close();
        } catch (Exception e) {
        }
    }


}
