package com.example.train.controller;

import com.example.train.config.VideoConfig;
import com.example.train.config.VideoUtil;
import com.example.train.pojo.*;
import com.example.train.service.ParticularsService;
import com.example.train.service.VideoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;

/**
 * @author tykj
 */
@RestController
@RequestMapping("/model4")
@Api(tags = "浙江省培训管理系统",description = "基础接口")
public class Controller {

    @Autowired
   private ParticularsService particularsService;

    @Autowired
    private VideoService videoService;



    @GetMapping("/findParticulars")
    @ApiOperation(value = "根据ID查询培训详情")
    public Particulars findParticularsById(Integer id){
        return particularsService.findParticularsById(id);
    }

    @PostMapping("/findAll")
    @ApiOperation(value = "动态查询培训信息")
    public PagePojo findAll(ParticularsCondition particularsCondition) {
        return particularsService.findAll(particularsCondition);
    }


    @PostMapping("/saveParticulars")
    @ApiOperation(value = "发起培训")
    public Particulars saveParticulars(Particulars particulars, MultipartFile file1,MultipartFile file2) throws IOException {
        String upload1 = particularsService.upload(file1);
        String upload2 = particularsService.upload(file2);
        particulars.setCoursewareUpload(upload1);
        particulars.setDataUpload(upload2);
        return particularsService.saveOne(particulars);
    }


    @PostMapping("/saveVideo")
    @ApiOperation(value = "视频上传")
    public Video saveVideo(Video video,MultipartFile videoFile) throws IOException{

        String videoUpload = videoService.uploadVideo(videoFile);
        video.setVideoUpload(videoUpload);
        video.setVideoLength(VideoUtil.getDurationBackString(videoUpload));
        return videoService.saveVideo(video);
    }

    @PostMapping("findVideo")
    @ApiOperation(value = "视频动态查询")
    public PagePojo findVideo(VideoCondition videoCondition){
        return videoService.findVideo(videoCondition);
    }

    @DeleteMapping("deleteById")
    @ApiOperation(value = "根据ID批量删除对象")
    public ResponseEntity deleteById(@RequestBody List<Integer> deleteIds){
        videoService.deleteById(deleteIds);
        return ResponseEntity.status(403).body("成功删除");
    }














}
