package com.example.train.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("培训详情")
public class Particulars {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "培训主键ID",example = "1")
    private Integer id;

    @ApiModelProperty(value = "发起人",example = "小明")
    private String name;

    @ApiModelProperty(value = "培训类型",example = "线上培训")
    private String type;

    @ApiModelProperty(value = "培训主题",example = "学习十九大精神")
    private String typeTitle;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd")
    @ApiModelProperty(value = "报名截止时间",example = "2022-1-1")
    private Date applyDate;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd")
    @ApiModelProperty(value = "培训开始时间",example = "2022-1-1")
    private Date trainStartDate;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd")
    @ApiModelProperty(value = "培训结束时间",example = "2022-1-1")
    private Date trainEndDate;

    @ApiModelProperty(value = "主办单位",example = "浙江省机要局")
    private String hostUnit;

    @ApiModelProperty(value = "培训简介",example = "输入一段简介文字")
    private String process;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd")
    @ApiModelProperty(value = "考试时间",example = "2022-1-1")
    private Date examDate;

    @ApiModelProperty(value = "考试时长",example = "60")
    private Long examTime;

    @ApiModelProperty(value = "试卷",example = "1")
    private Integer examPaper;

    @ApiModelProperty(value = "课件上传",example = "课件保存路径")
    private String coursewareUpload;

    @ApiModelProperty(value = "资料上传",example = "资料保存路径")
    private String dataUpload;

    @Transient
    @ApiModelProperty(value = "培训对象",example = "杭州市机要局")
    private List<ParticularsChildren> particularsChildrenList;







}
