package com.example.train.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("培训查询条件")
public class ParticularsCondition {

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd")
    @ApiModelProperty(value = "培训开始时间",example = "2022-1-1")
    private Date trainStartDate;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd")
    @ApiModelProperty(value = "培训结束时间",example = "2022-1-1")
    private Date trainEndDate;

    @ApiModelProperty(value = "培训主题",example = "学习十九大精神")
    private String typeTitle;

    @ApiModelProperty(value = "页码",example = "1")
    private Integer page;

    @ApiModelProperty(value = "请求数量",example = "1")
    private Integer pageSize;


}
