package com.example.train.pojo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * @author tykj
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("视频详情")
public class Video {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "视频主键ID",example = "1")
    private Integer id;

    @ApiModelProperty(value = "视频标题",example = "输入一段文字")
    private String videoTitle;

    @ApiModelProperty(value = "视频分类",example = "分类1")
    private String videoType;

    @ApiModelProperty(value = "视频简介",example = "输入一段文字")
    private String videoProcess;

    @ApiModelProperty(value = "视频上传",example = "视频保存路径")
    private String videoUpload;

    @ApiModelProperty(value = "视频长度",example = "30")
    private String videoLength;




}
