package com.example.train.service;

import com.example.train.pojo.PagePojo;
import com.example.train.pojo.Particulars;
import com.example.train.pojo.Video;
import com.example.train.pojo.VideoCondition;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

/**
 * @author tykj
 */
public interface VideoService {


    /**
     * 视频上传
     * @param file
     * @return
     * @throws IOException
     */
    String uploadVideo(MultipartFile file) throws IOException;

    /**
     * 创建视频
     * @param video
     * @return
     */
    Video saveVideo(Video video);

    /**
     * 动态查询视频信息
     * @param videoCondition
     * @return
     */
    PagePojo findVideo(VideoCondition videoCondition);


    /**
     * 批量删除视频
     * @param deleteIds
     */
    void deleteById(List<Integer> deleteIds);
}
