package com.example.train.service.impl;

import com.example.train.dao.ParticularsChildrenDao;
import com.example.train.dao.ParticularsDao;
import com.example.train.pojo.*;
import com.example.train.service.ParticularsService;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author tykj
 */
@Service
@Slf4j
public class ParticularsServiceImpl implements ParticularsService {


    @Autowired
    private ParticularsDao particularsDao;

    @Autowired
    private ParticularsChildrenDao particularsChildrenDao;



    /**
     * 文件上传方法
     * @param file
     * @return
     * @throws IOException
     */
    @Override
    public String upload(MultipartFile file) throws IOException {
        //MultipartFile 接收前端传过来的文件
        // 注意 前端传参的name要和MultipartFile的对象名保持一直 比如此处对象名为file 则前端传参的name也要为file
        //获取上传文件的文件名
        String oldName=file.getOriginalFilename();
        //指定上传路径
        String path="C:\\Intel\\上传文件夹\\";
        //拼接成为新文件的路径
        String filePath=path+oldName;
        //创建新文件对象 指定文件路径为拼接好的路径
        File newFile=new File(filePath);
        //将前端传递过来的文件输送给新文件 这里需要抛出IO异常 throws IOException
        file.transferTo(newFile);
        //上传完成后将文件路径返回给前端用作图片回显或增加时的文件路径值等
        return filePath;
    }

    @Override
    public Particulars saveOne(Particulars particularsSave) {
        List<ParticularsChildren> particularsChildren = particularsChildrenDao.saveAll(particularsSave.getParticularsChildrenList());
        Particulars save = particularsDao.save(particularsSave);
        save.setParticularsChildrenList(particularsChildren);
        return findParticularsById(save.getId());
    }


    @Override
    public Particulars findParticularsById(Integer id) {
        List<ParticularsChildren> byTrainingId = particularsChildrenDao.findParticularsChildrenByTrainingId(id);
        Particulars particulars = particularsDao.findById(id).get();
        particulars.setParticularsChildrenList(byTrainingId);
        return particulars;
    }

    @Override
    public PagePojo findAll(ParticularsCondition particularsCondition){
        //根据传入的数据，进行分页数据查询
        PageRequest of = PageRequest.of(particularsCondition.getPage(), particularsCondition.getPageSize());

        //动态查询构造器
        Specification<Particulars> queryCondition = new Specification<Particulars>(){
            @Override
            public Predicate toPredicate(Root<Particulars> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                List<Predicate> predicateList = new ArrayList<>();
                if (particularsCondition.getTrainStartDate()!=null){
                    predicateList.add(criteriaBuilder.greaterThan(root.get("trainStartDate").as(Date.class),particularsCondition.getTrainStartDate()));
                }
                if (particularsCondition.getTrainEndDate()!=null){
                    predicateList.add(criteriaBuilder.lessThan(root.get("trainEndDate").as(Date.class),particularsCondition.getTrainEndDate()));
                }
                if (particularsCondition.getTypeTitle()!=null){
                    predicateList.add(criteriaBuilder.like(root.get("typeTitle"),"%" + particularsCondition.getTypeTitle() + "%"));
                }
                return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
            }
        };

        Page<Particulars> allParticulars = particularsDao.findAll(queryCondition,of);


       //循环赋值，把对象倒入VO
        List<ParticularsVO> particularsVOList =new ArrayList<>();
        List<Particulars> contentParticulars = allParticulars.getContent();
        for (Particulars particulars : contentParticulars){
            ParticularsVO particularsVO = new ParticularsVO();
            BeanUtils.copyProperties(particulars,particularsVO);
            //当前时间小于报名时间
            if (new Date().before(particulars.getApplyDate())){
                particularsVO.setTrainState("报名中");
                //当前时间大于报名时间，小于培训时间
            }else if(new Date().after(particulars.getApplyDate()) && new Date().before(particulars.getTrainStartDate())){
                particularsVO.setTrainState("待培训");
                //当前时间大于培训时间，小于考试时间
            }else if (new Date().after(particulars.getTrainStartDate()) && new Date().before(particulars.getExamDate())){
                particularsVO.setTrainState("培训中");
                //当前时间大于考试时间，小于培训结束时间
            }else if(new Date().after(particulars.getExamDate()) && new Date().before(particulars.getTrainEndDate())){
                particularsVO.setTrainState("待考试");
                //当前时间大于培训结束时间
            }else if(new Date().after(particulars.getTrainEndDate())){
                particularsVO.setTrainState("培训结束");
            }
            particularsVOList.add(particularsVO);
        }
        PagePojo pagePojo = new PagePojo();
        pagePojo.setPage(particularsCondition.getPage());
        pagePojo.setPageSize(particularsCondition.getPageSize());
        pagePojo.setTotal(allParticulars.getTotalElements());
        pagePojo.setParticularsVOList(particularsVOList);

        return pagePojo;
    }


}
