package com.example.train.service.impl;

import com.example.train.dao.VideoDao;
import com.example.train.pojo.PagePojo;
import com.example.train.pojo.Particulars;
import com.example.train.pojo.Video;
import com.example.train.pojo.VideoCondition;
import com.example.train.service.VideoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author tykj
 */
@Service
@Slf4j
public class VideoServiceImpl implements VideoService {

    @Autowired
    private VideoDao videoDao;

    /**
     * 文件上传方法
     * @param file
     * @return
     * @throws IOException
     */
    @Override
    public String uploadVideo(MultipartFile file) throws IOException {
        //MultipartFile 接收前端传过来的文件
        // 注意 前端传参的name要和MultipartFile的对象名保持一直 比如此处对象名为file 则前端传参的name也要为file
        //获取上传文件的文件名
        String oldName=file.getOriginalFilename();
        //指定上传路径
        String path="C:\\Intel\\视频文件夹\\";
        //拼接成为新文件的路径
        String filePath=path+oldName;
        //创建新文件对象 指定文件路径为拼接好的路径
        File newFile=new File(filePath);
        //将前端传递过来的文件输送给新文件 这里需要抛出IO异常 throws IOException
        file.transferTo(newFile);
        //上传完成后将文件路径返回给前端用作图片回显或增加时的文件路径值等
        return filePath;
    }

    @Override
    public Video saveVideo(Video video) {
        return videoDao.save(video);
    }

    @Override
    public PagePojo findVideo(VideoCondition videoCondition) {
        //根据传入的数据，进行分页数据查询
        PageRequest of = PageRequest.of(videoCondition.getPage(), videoCondition.getPageSize());
        //动态查询构造器
        Specification<Video> queryCondition = new Specification<Video>() {
            @Override
            public Predicate toPredicate(Root<Video> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                List<Predicate> predicateList = new ArrayList<>();
                if(videoCondition.getTypeTitle()!=null){
                    predicateList.add(criteriaBuilder.like(root.get("videoTitle"),"%" + videoCondition.getTypeTitle() + "%"));
                }
                if(videoCondition.getTypeProcess()!=null){
                    predicateList.add(criteriaBuilder.like(root.get("videoProcess"),"%" + videoCondition.getTypeProcess() + "%"));
                }
                if (videoCondition.getVideoType()!=null){
                    predicateList.add(criteriaBuilder.equal(root.get("videoType"),videoCondition.getVideoType()));
                }

                return criteriaBuilder.and(predicateList.toArray(new Predicate[predicateList.size()]));
            }
        };

        Page<Video> videoDaoAll = videoDao.findAll(queryCondition, of);
        List<Video> videoList = videoDaoAll.getContent();

        PagePojo pagePojo = new PagePojo();
         pagePojo.setPage(videoCondition.getPage());
         pagePojo.setPageSize(videoCondition.getPageSize());
         pagePojo.setVideoList(videoList);
        return pagePojo;
    }

    @Override
    public void deleteById(List<Integer> deleteIds) {
        for (Integer id : deleteIds){
            String videoUpload = videoDao.findById(id).get().getVideoUpload();
            File file = new File(videoUpload);
            file.delete();
        }
        videoDao.deleteAllByIdIn(deleteIds);
    }
}
