package com.example.train.pojo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * @author tykj
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel("培训对象")
public class ParticularsChildren {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty(value = "培训对象ID",example = "1")
    private Integer id;

    @ApiModelProperty(value = "培训ID",example = "1")
    private Integer trainingId;

    @ApiModelProperty(value = "地区名",example = "浙江")
    private String areaName;

    @ApiModelProperty(value = "单位名",example = "科技管理处")
    private String mechanismName;


}
