package com.example.train.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author tykj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ParticularsVO {

    @ApiModelProperty(value = "序号ID",example = "1")
    private Integer id;

    @ApiModelProperty(value = "培训主题",example = "学习十九大精神")
    private String typeTitle;

    @ApiModelProperty(value = "主办单位",example = "浙江省机要局")
    private String hostUnit;


    @ApiModelProperty(value = "培训发起人",example = "小明")
    private String name;

    @JsonFormat(shape =JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone ="GMT+8")
    @DateTimeFormat(pattern= "yyyy-MM-dd")
    @ApiModelProperty(value = "培训日期",example = "2022-1-1")
    private Date trainStartDate;

    @ApiModelProperty(value = "培训类型",example = "线上培训")
    private String type;

    @ApiModelProperty(value = "培训状态",example = "报名中")
    private String trainState;



}
