package com.example.train.service;

import com.example.train.pojo.PagePojo;
import com.example.train.pojo.Particulars;
import com.example.train.pojo.ParticularsCondition;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.text.ParseException;

/**
 * @author tykj
 */
public interface ParticularsService {


    /**
     * 根据ID查询培训详情
     * @param id
     * @return
     */
   Particulars findParticularsById(Integer id);

    /**
     * 根据条件动态查询培训信息
     * @param particularsCondition
     * @return
     * @throws ParseException
     */
   PagePojo findAll(ParticularsCondition particularsCondition);


    /**
     * 文件上传
     * @param file
     * @return
     * @throws IOException
     */
   String upload(MultipartFile file) throws IOException;


    /**
     * 发起培训
     * @param particularsSave
     * @return
     */
   Particulars saveOne(Particulars particularsSave);

}
